
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Apr 01 12:09:38 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_SEP_ATP_Data.c#1:csrc:1
   *  \author taniam
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/************* Include Files ***********************************/
#include "stdio.h"
#include "SST_SEP_TST.h"
#include "SEP_ATP_UTIL_funcs.h"
#include "gen_release.h"

/************************ Global Data **************************/
extern TST_ATP_DataOpTestDataStruct* TST_ATP_DataOpTestData;
/************************ Public Functions *********************/
/*****************************************************************************
* Function Name:
*  SEPQA_SST_BasicDataOp
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:
* Test the creation, deletion, modification, opening, closing and usage of a password authenticator object. 
* And demonstrate the use of transaction with authenticator objects
*
* Algorithm:
*    1.  Create a new session by calling: SST_SessionCreate.
*    2.  Open a transaction by calling: SST_TransactionStart.
*    3.  Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
*    4.  Close the transaction by calling: SST_TransactionEnd. 
*    5.  Open the new authenticator by calling: SST_AuthenticationOpen.
*    6.  Open a transaction by calling: SST_TransactionStart.
*    7.  Insert a new data object by calling: SST_InsertData.
*    8.  Close the transaction by calling: SST_TransactionEnd.
*    9.  Read and compare the inserted data by calling: SST_ReadData.
*    10. Open a transaction by calling: SST_TransactionStart.
*    11. Modify the data from selected location by calling: SST_ModifyData.
*    12. Close the transaction by calling: SST_TransactionEnd.
*    13. Read and compare the modified data by calling: SST_ReadData.
*    14. Get the data size and compare to known by calling: SST_GetDataSize.
*    15. Open a transaction by calling: SST_TransactionStart.
*    16. Delete the data by calling: SST_DeleteData.
*    17. Delete the authenticator by calling: SST_AuthenticatorDelete.
*    18. Close the transaction by calling: SST_TransactionClose.
*    19. Delete the session by calling: SST_SessionDelete.
********************************************************************************/    
DxError_t SEPQA_SST_BasicDataOp ( void )
{
    /********* TST Variables Definitions ************/
    DxUint32_t                  TST_index = 0;
    DxUint32_t                  TST_Error = 0;
    DxUint32_t                  TST_Status = 0;
    DxChar                      TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_BasicDataOp";
    SSTSessionId_t              TST_SessionId; 
    SSTTxnId_t                  TST_TransactionId;
    SSTHandle_t                 TST_AuthHandle;
    SSTHandle_t                 TST_DataHandle;
    SSTDataType_t               TST_SimpleData = TST_DATA_OBJECT;
    DxUint32_t                  TST_TempDataSize,TST_OutputDataSize;
    SSTHandle_t                 TST_AuthDefaultHandle;

    /********* TST Variables initialization *********/
    TST_Status = TESTPASS;
    TST_AuthHandle.objId = SST_HANDLE_RANDOM_GENERATE; 
    TST_DataHandle.objId = SST_HANDLE_RANDOM_GENERATE;

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/

    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ************  SEPQA_SST_BasicDataOp Test ************* \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n \n"));

    ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using internal handles          \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));



    /* Create a session for operations */
    /*---------------------------------*/
    TST_Status = SST_SessionCreate(&TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                               "SEPQA_SST_BasicDataOp",TST_MasterTestName);


    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               "SEPQA_SST_BasicDataOp",TST_MasterTestName);

    /* Create a new password authenticator */
    /*-------------------------------------*/
    TST_AuthDefaultHandle.objDigest = 0;
    TST_AuthDefaultHandle.objId = SST_CLOSE_AUTH_HANDLE;
    TST_Error = SST_AuthenticatorPasswordCreate(TST_TransactionId,
                                                TST_SessionId,
                                                TST_ATP_DataOpTestData[TST_index].TST_Password,
                                                TST_ATP_DataOpTestData[TST_index].TST_PasswordSizeInBytes,
                                                TST_ATP_DataOpTestData[TST_index].TST_MaxNumOfTrials,
                                                TST_AuthDefaultHandle,
                                                &TST_AuthHandle,
                                                TST_Workspace,
                                                TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorPasswordCreate",
                               "SEPQA_SST_BasicDataOp",TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               "SEPQA_SST_BasicDataOp",TST_MasterTestName);




    /* Open the password authentication */
    /*----------------------------------*/
    TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                        TST_AuthHandle,
                                        TST_ATP_DataOpTestData[TST_index].TST_Password,
                                        TST_ATP_DataOpTestData[TST_index].TST_PasswordSizeInBytes,
                                        TST_NO_CHALLENGE,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen",
                               "SEPQA_SST_BasicDataOp",TST_MasterTestName);

    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               "SEPQA_SST_BasicDataOp",TST_MasterTestName);

    /* Insert a new Data object */
    /*--------------------------*/

    TST_Status = SST_DataInsert(TST_TransactionId,
                                TST_SessionId,
                                TST_AuthHandle,
                                TST_ATP_DataOpTestData[TST_index].TST_Data,
                                TST_ATP_DataOpTestData[TST_index].TST_DataSize,
                                DX_TRUE,
                                TST_SimpleData,
                                &TST_DataHandle,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert",
                               "SEPQA_SST_BasicDataOp",TST_MasterTestName);

    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                   DX_TRUE,/*reflash sensitive*/
                                   TST_Workspace,
                                   TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               "SEPQA_SST_BasicDataOp",TST_MasterTestName);

    /* Read the data */
    /*---------------*/
    TST_TempDataSize = TST_ATP_DataOpTestData[TST_index].TST_DataSize;

    TST_Status = SST_DataRead(TST_SessionId,
                              TST_DataHandle,
                              TST_ATP_DataOpTestData[TST_index].TST_DataReadOffset,
                              TST_ATP_DataOpTestData[TST_index].TST_OutputData,
                              &TST_TempDataSize,
                              TST_Workspace,
                              TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataRead",
                               "SEPQA_SST_BasicDataOp",TST_MasterTestName);


    /* Compare the retrieved data to the original */
    /*--------------------------------------------*/
    if(!DX_VOS_MemCmp(TST_ATP_DataOpTestData[TST_index].TST_Data,
                      TST_ATP_DataOpTestData[TST_index].TST_OutputData,
                      TST_ATP_DataOpTestData[TST_index].TST_DataSize))
        TST_Status = TESTPASS; /*Data Buffers are the same*/
    else
        TST_Status = TESTFAIL; /*Data Buffers are different*/

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - Original data",
                               "SEPQA_SST_BasicDataOp",TST_MasterTestName);


    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               "SEPQA_SST_BasicDataOp",TST_MasterTestName);


    /* Modify the data from selected location */
    /*----------------------------------------*/
    TST_Status = SST_DataModify(TST_TransactionId,
                                TST_SessionId,
                                TST_DataHandle,
                                TST_ATP_DataOpTestData[TST_index].TST_DataToWrite,
                                TST_ATP_DataOpTestData[TST_index].TST_DataToWriteSize,
                                TST_ATP_DataOpTestData[TST_index].TST_DataToWriteOffset,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);


    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataModify",
                               "SEPQA_SST_BasicDataOp",TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               "SEPQA_SST_BasicDataOp",TST_MasterTestName);


    /* Read the data */
    /*---------------*/
    TST_TempDataSize = TST_ATP_DataOpTestData[TST_index].TST_DataSize;

    TST_Status = SST_DataRead(TST_SessionId,
                              TST_DataHandle,
                              TST_ATP_DataOpTestData[TST_index].TST_DataReadOffset,
                              TST_ATP_DataOpTestData[TST_index].TST_OutputData,
                              &TST_TempDataSize,
                              TST_Workspace,
                              TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataRead",
                               "SEPQA_SST_BasicDataOp",TST_MasterTestName);


    /* Compare the retrieved data to the original */
    /*--------------------------------------------*/
    if(!DX_VOS_MemCmp(TST_ATP_DataOpTestData[TST_index].TST_ModifedData,
                      TST_ATP_DataOpTestData[TST_index].TST_OutputData,
                      TST_ATP_DataOpTestData[TST_index].TST_DataSize))
        TST_Status = TESTPASS; /*Data Buffers are the same*/
    else
        TST_Status = TESTFAIL; /*Data Buffers are different*/

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - Modified data",
                               "SEPQA_SST_BasicDataOp",TST_MasterTestName);



    /* Get Data Size and compare */
    /*---------------------------*/
    TST_Status = SST_DataSizeGet(TST_SessionId,
                                 TST_DataHandle,
                                 &TST_OutputDataSize,
                                 TST_Workspace,
                                 TST_WorkspaceSizeInBytes);


     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataSizeGet",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);


    /* Compare retrieved data size to original */
    /*-----------------------------------------*/
    if(!DX_VOS_MemCmp(&TST_OutputDataSize,
                      &TST_ATP_DataOpTestData[TST_index].TST_DataSize,
                      sizeof(TST_OutputDataSize)))
        TST_Status = TESTPASS; /*Data Buffers are the same*/
    else
        TST_Status = TESTFAIL; /*Data Buffers are different*/

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - data size",
                               "SEPQA_SST_BasicDataOp",TST_MasterTestName);


    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               "SEPQA_SST_BasicDataOp",TST_MasterTestName);


    /* Delete the data */
    /*-----------------*/
    TST_Status = SST_DataDelete(TST_TransactionId,
                                TST_SessionId,
                                TST_DataHandle,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete",
                               "SEPQA_SST_BasicDataOp",TST_MasterTestName);


    /* Delete the authenticator */
    /*--------------------------*/
    TST_Status = SST_AuthenticatorDelete(TST_TransactionId,
                                         TST_AuthHandle);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete - Master authenticator",
                               "SEPQA_SST_BasicDataOp",TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               "SEPQA_SST_BasicDataOp",TST_MasterTestName);


    /* Delete the session */
    /*--------------------*/
    TST_Status = SST_SessionDelete(TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                               "SEPQA_SST_BasicDataOp",TST_MasterTestName);


  EXIT_ON_ERROR:
    return TST_Status;
}/* End of SEPQA_SST_BasicDataOp */

/*****************************************************************************
* Function Name:
*  SEPQA_SST_BasicUnAuthnticatedDataOp
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:
* Test the insertion, deletion, modification, opening, getting data size for a data object using default internal authenticator.
* And demonstration on the use of transaction with data objects
*  
* Algorithm:       
*    1.    Create a new session by calling: SST_SessionCreate.
*    2.    Open a transaction by calling: SST_TransactionStart.
*    3.    Insert a new data object by calling: SST_InsertData.
*    4.    Close the transaction by calling: SST_TransactionEnd.
*    5.    Read and compare the inserted data by calling: SST_ReadData.
*    6.    Open a transaction by calling: SST_TransactionStart.
*    7.    Modify the data from selected location by calling: SST_ModifyData.
*    8.    Close the transaction by calling: SST_TransactionEnd.
*    9.    Read and compare the modified data by calling: SST_ReadData.
*   10.    Get the data size and compare to known by calling: SST_GetDataSize.
*   11.    Open a transaction by calling: SST_TransactionStart.
*   12.    Delete the data by calling: SST_DeleteData.
*   13.    Close the transaction by calling: SST_TransactionClose.
*   14.    Delete the session by calling: SST_SessionDelete.
*
*******************************************************************************/
DxError_t SEPQA_SST_BasicUnAuthnticatedDataOp ( void )
{
    /********* TST Variables Definitions ************/
    DxUint32_t                  TST_index = 0;
    DxUint32_t                  TST_Status = 0;
    DxChar                      TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_BasicUnAuthnticatedDataOp";
    SSTSessionId_t              TST_SessionId; 
    SSTTxnId_t                  TST_TransactionId;
    SSTHandle_t                 TST_DataHandle;
    SSTDataType_t               TST_SimpleData = TST_DATA_OBJECT;
    DxUint32_t                  TST_TempDataSize,TST_OutputDataSize;
    SSTHandle_t                 TST_AuthDefaultHandle;

    /********* TST Variables initialization *********/
    TST_Status = TESTPASS;
    TST_DataHandle.objId = SST_HANDLE_RANDOM_GENERATE;

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    ATP_LOG_TST_PRINT((SST_TST_MSG," ******************************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," **    SEPQA_SST_BasicUnAuthnticatedDataOp Test ********************* \n"));     
    ATP_LOG_TST_PRINT((SST_TST_MSG," ******************************************************************** \n \n"));

    ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using internal handles          \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));


    /* Create a session for operations */
    /*---------------------------------*/
    TST_Status = SST_SessionCreate(&TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                               "SEPQA_SST_BasicUnAuthnticatedDataOp",TST_MasterTestName);

    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               "SEPQA_SST_BasicUnAuthnticatedDataOp",TST_MasterTestName);


    /* Insert a new Data object */
    /*--------------------------*/
    TST_AuthDefaultHandle.objDigest = 0;
    TST_AuthDefaultHandle.objId = SST_CLOSE_AUTH_HANDLE;
    TST_Status = SST_DataInsert(TST_TransactionId,
                                TST_SessionId,
                                TST_AuthDefaultHandle,
                                TST_ATP_DataOpTestData[TST_index].TST_Data,
                                TST_ATP_DataOpTestData[TST_index].TST_DataSize,
                                DX_TRUE,
                                TST_SimpleData,
                                &TST_DataHandle,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert",
                               "SEPQA_SST_BasicUnAuthnticatedDataOp",TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               "SEPQA_SST_BasicUnAuthnticatedDataOp",TST_MasterTestName);



    /* Read the data */
    /*---------------*/
    TST_TempDataSize = TST_ATP_DataOpTestData[TST_index].TST_DataSize;

    TST_Status = SST_DataRead(TST_SessionId,
                              TST_DataHandle,
                              TST_ATP_DataOpTestData[TST_index].TST_DataReadOffset,
                              TST_ATP_DataOpTestData[TST_index].TST_OutputData,
                              &TST_TempDataSize,
                              TST_Workspace,
                              TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataRead",
                               "SEPQA_SST_BasicUnAuthnticatedDataOp",TST_MasterTestName);



    /* Compare the retrieved data to the original */
    /*--------------------------------------------*/
    if(!DX_VOS_MemCmp(TST_ATP_DataOpTestData[TST_index].TST_Data,
                      TST_ATP_DataOpTestData[TST_index].TST_OutputData,
                      TST_ATP_DataOpTestData[TST_index].TST_DataSize))
        TST_Status = TESTPASS; /*Data Buffers are the same*/
    else
        TST_Status = TESTFAIL; /*Data Buffers are different*/

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - Original data",
                               "SEPQA_SST_BasicUnAuthnticatedDataOp",TST_MasterTestName);


    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               "SEPQA_SST_BasicUnAuthnticatedDataOp",TST_MasterTestName);


    /* Modify the data from selected location */
    /*----------------------------------------*/
    TST_Status = SST_DataModify(TST_TransactionId,
                                TST_SessionId,
                                TST_DataHandle,
                                TST_ATP_DataOpTestData[TST_index].TST_DataToWrite,
                                TST_ATP_DataOpTestData[TST_index].TST_DataToWriteSize,
                                TST_ATP_DataOpTestData[TST_index].TST_DataToWriteOffset,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataModify",
                               "SEPQA_SST_BasicUnAuthnticatedDataOp",TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

        TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                                   "SEPQA_SST_BasicUnAuthnticatedDataOp",TST_MasterTestName);



    /* Read the data */
    /*---------------*/
    TST_TempDataSize = TST_ATP_DataOpTestData[TST_index].TST_DataSize;

    TST_Status = SST_DataRead(TST_SessionId,
                              TST_DataHandle,
                              TST_ATP_DataOpTestData[TST_index].TST_DataReadOffset,
                              TST_ATP_DataOpTestData[TST_index].TST_OutputData,
                              &TST_TempDataSize,
                              TST_Workspace,
                              TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataRead",
                               "SEPQA_SST_BasicUnAuthnticatedDataOp",TST_MasterTestName);



    /* Compare the retrieved data to the original */
    /*--------------------------------------------*/
    if(!DX_VOS_MemCmp(TST_ATP_DataOpTestData[TST_index].TST_ModifedData,
                      TST_ATP_DataOpTestData[TST_index].TST_OutputData,
                      TST_ATP_DataOpTestData[TST_index].TST_DataSize))
        TST_Status = TESTPASS; /*Data Buffers are the same*/
    else
        TST_Status = TESTFAIL; /*Data Buffers are different*/

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - Modified data",
                               "SEPQA_SST_BasicUnAuthnticatedDataOp",TST_MasterTestName);



    /* Get Data Size and compare */
    /*---------------------------*/
    TST_Status = SST_DataSizeGet(TST_SessionId,
                                 TST_DataHandle,
                                 &TST_OutputDataSize,
                                 TST_Workspace,
                                 TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataSizeGet",
                               "SEPQA_SST_BasicUnAuthnticatedDataOp",TST_MasterTestName);


    /* Compare retrieved data size to original */
    /*-----------------------------------------*/
    if(!DX_VOS_MemCmp(&TST_OutputDataSize,
                      &TST_ATP_DataOpTestData[TST_index].TST_DataSize,
                      sizeof(TST_OutputDataSize)))
        TST_Status = TESTPASS; /*Data Buffers are the same*/
    else
        TST_Status = TESTFAIL; /*Data Buffers are different*/

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - data size",
                               "SEPQA_SST_BasicUnAuthnticatedDataOp",TST_MasterTestName);

    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               "SEPQA_SST_BasicUnAuthnticatedDataOp",TST_MasterTestName);


    /* Delete the data */
    /*-----------------*/
    TST_Status = SST_DataDelete(TST_TransactionId,
                                TST_SessionId,
                                TST_DataHandle,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete",
                               "SEPQA_SST_BasicUnAuthnticatedDataOp",TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               "SEPQA_SST_BasicUnAuthnticatedDataOp",TST_MasterTestName);


    /* Delete the session */
    /*--------------------*/
    TST_Status = SST_SessionDelete(TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                               "SEPQA_SST_BasicUnAuthnticatedDataOp",TST_MasterTestName);


  EXIT_ON_ERROR:
    return TST_Status;

}/* End of SST_TST_ATP_BasicUnAuthnticatedDataOp */
/*****************************************************************************
* Function Name:
*  SEPQA_SST_DataReplace
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:
* Test data replace operation
*  
* Algorithm:
*    1. Create a new session by calling SST_SessionCreate.
*    2. Open a transaction by calling SST_TransactionStart.
*    3. Insert a new data object by calling SST_InsertData.
*    4. Replace the content of the data by calling SST_DataReplace.
*    5. Verify the data was actually replaced by calling SST_DataRead and comparing the data.
*    6. Delete the data by calling SST_DataDelete.
*    7. Close the transaction by calling SST_TransactionEnd.
*    8. Delete the session by calling SST_SessionDelete.
********************************************************************************/
DxError_t SEPQA_SST_DataReplace ( void )
{
    /********* TST Variables Definitions ************/
    SSTSessionId_t           TST_SessionId;
    DxUint32_t               TST_index = 0;
    DxChar                   * TestName = "ATP test SST Data Replace";
    SSTTxnId_t               TST_TransactionId;
    SSTHandle_t              TST_DataHandle;
    SSTHandle_t              TST_AuthHandle;
    SSTHandle_t              TST_AuthDefaultHandle;
    SSTDataType_t            TST_SimpleData = TST_DATA_OBJECT;
    DxUint32_t               TST_DataSize;
    DxError_t                TST_Status;
    DxByte_t                 TST_DataBuff1[TST_BUFF1_SIZE_IN_BYTES]={1};
    DxByte_t                 TST_DataBuff2[TST_BUFF1_SIZE_IN_BYTES]={2};
    DxByte_t                 TST_DataBuff3[TST_BUFF1_SIZE_IN_BYTES]={0};

    /********* TST Variables initialization *********/
    TST_DataHandle.objId = SST_HANDLE_RANDOM_GENERATE;
    TST_Status = TESTPASS;

    /* Create a session for operations */
    /*---------------------------------*/
    TST_Status = SST_SessionCreate(&TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                               "SST_SessionCreate",
                               TestName,
                               TestName);


    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                               "SST_TransactionStart",
                               TestName,
                               TestName);


    /* Create a new password authenticator */
    /*-------------------------------------*/
    TST_AuthDefaultHandle.objDigest = 0;
    TST_AuthDefaultHandle.objId = SST_CLOSE_AUTH_HANDLE;
    TST_Status = SST_AuthenticatorPasswordCreate(TST_TransactionId,
                                                 TST_SessionId,
                                                 TST_ATP_DataOpTestData[TST_index].TST_Password,
                                                 TST_ATP_DataOpTestData[TST_index].TST_PasswordSizeInBytes,
                                                 TST_ATP_DataOpTestData[TST_index].TST_MaxNumOfTrials,
                                                 TST_AuthDefaultHandle,
                                                 &TST_AuthHandle,
                                                 TST_Workspace,
                                                 TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorPasswordCreate",
                               TestName,
                               TestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               TestName,
                               TestName);


    /* Open the password authentication */
    /*----------------------------------*/
    TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                        TST_AuthHandle,
                                        TST_ATP_DataOpTestData[TST_index].TST_Password,
                                        TST_ATP_DataOpTestData[TST_index].TST_PasswordSizeInBytes,
                                        TST_NO_CHALLENGE,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen - Passeord",
                               TestName,
                               TestName);


    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               TestName,
                               TestName);

   /* Insert a new Data object */
   /*--------------------------*/
   TST_Status = SST_DataInsert(TST_TransactionId,
                               TST_SessionId, 
                               TST_AuthHandle,
                               TST_DataBuff1,
                               sizeof(TST_DataBuff1),
                               DX_TRUE,
                               TST_SimpleData,
                               &TST_DataHandle,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                               "SST_DataInsert",
                               TestName,
                               TestName);


    /*Replace the content of the data by calling SST_DataReplace*/
    /*----------------------------------------------------------*/
    TST_Status = SST_DataReplace(TST_TransactionId,
                                 TST_SessionId,
                                 TST_DataHandle,
                                 TST_DataBuff2,
                                 sizeof(TST_DataBuff2),
                                 DX_TRUE,
                                 TST_Workspace,
                                 TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                               "SST_DataReplace",
                               TestName,
                               TestName);


    /*Verify the data was actually replaced by calling SST_DataRead and comparing the data*/
    /*------------------------------------------------------------------------------------*/
    TST_DataSize = sizeof(TST_DataBuff3);
    TST_Status = SST_DataRead(TST_SessionId,
                              TST_DataHandle,
                              0,
                              TST_DataBuff3,
                              &TST_DataSize,
                              TST_Workspace,
                              TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                               "SST_DataRead",
                               TestName,
                               TestName);


    if(TST_DataSize == TST_BUFF2_SIZE_IN_BYTES)
        TST_Status = TESTPASS;
    else
        TST_Status = TESTFAIL;

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                               "Data size",
                               TestName,
                               TestName);


    if(!DX_VOS_MemCmp(TST_DataBuff3,TST_DataBuff2,TST_DataSize))
        TST_Status = TESTPASS;
    else
          TST_Status = TESTFAIL;


    TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                               "DX_VOS_MemCmp",
                               TestName,
                               TestName);


    /*Delete the data by calling SST_DataDelete*/
    /*-----------------------------------------*/
    TST_Status = SST_DataDelete(TST_TransactionId,
                                TST_SessionId,
                                TST_DataHandle,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                               "SST_DataDelete",
                               TestName,
                               TestName);

    /* Delete the authenticator */
    /*--------------------------*/
    TST_Status = SST_AuthenticatorDelete(TST_TransactionId,
                                         TST_AuthHandle);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete - Master authenticator",
                               TestName,
                               TestName);

    /*Close the transaction by calling SST_TransactionEnd*/
    /*---------------------------------------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                               "SST_TransactionEnd",
                               TestName,
                               TestName);


    /*Delete the session by calling SST_SessionDelete*/
    /*---------------------------------- ------------*/
    TST_Status = SST_SessionDelete(TST_SessionId);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,
                               "SST_SessionDelete",
                               TestName,
                               TestName);




  EXIT_ON_ERROR:
    return TST_Status;

}




